(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type t = { tbl: (string, Intvllist.t) Hashtbl.t;
	   revtbl: (Intvllist.t, string) Hashtbl.t }

let create n =
  { tbl = Hashtbl.create n; revtbl = Hashtbl.create n }

let define intvllisttbl name intvllist =
  Hashtbl.replace intvllisttbl.tbl name intvllist;
  Hashtbl.replace intvllisttbl.revtbl intvllist name

let lookup intvllisttbl name =
  Hashtbl.find intvllisttbl.tbl name

let revlookup intvllisttbl intvllist =
  Hashtbl.find intvllisttbl.revtbl intvllist

let keys intvllisttbl =
  Hashtbl.fold (fun k _ list -> k :: list) intvllisttbl.tbl []
