(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type t = { note : Note.t; octave : int; }
val to_notenum : t -> int
val of_notenum : int -> t
val of_note_octave : Note.t -> int -> t
val to_note_octave : t -> Note.t * int
val of_string : string -> t
val to_string : t -> string
val pp : Format.formatter -> t -> unit
val note : t -> Note.t
val octave : t -> int
val compare : t -> t -> int
val equal : t -> t -> bool
val hash : t -> int
val add_int : t -> int -> t
val sub_int : t -> int -> t
val sub_midinote : t -> t -> int
val of_notenum_in_notelist : int -> Note.t list -> t
