(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type t = { n : int; alt : int; }
val of_string : string -> t
val to_string : t -> string
val pp : Format.formatter -> t -> unit
val of_n_alt : int -> int -> t
val to_n_alt : t -> int * int
val compare : t -> t -> int
val equal : t -> t -> bool
val hash : t -> int
val semi : t -> int
val add_intvl : t -> Intvl.t -> t
val sub_intvl : t -> Intvl.t -> t
val sub_note : t -> t -> Intvl.t
