(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

open Num

type 'a t = (num * num * 'a) list * bool

let create () =
  [], true

let compare (ts1, _, _) (ts2, _, _) =
  compare_num ts1 ts2

let rev_compare e1 e2 =
  - compare e1 e2

let add ts dur event seq =
  let e = ts, dur, event in
    match seq with
	[], _ ->
	  e :: [], true
      | hd :: tl, is_rev_sorted ->
	  e :: hd :: tl, is_rev_sorted && compare e hd >= 0

let events seq =
  match seq with
      events, true ->
	List.rev events
    | events, false ->
	List.sort compare events

let merge seq1 seq2 =
  if snd seq1 && snd seq2 then
    List.merge rev_compare (fst seq1) (fst seq2), true
  else
    List.append (fst seq1) (fst seq2), false

let rec test_rev_sorted events =
  match events with
    [] -> true
  | x :: [] -> true
  | x :: y :: tl -> (compare x y) >= 0 && test_rev_sorted (y :: tl)

let map f seq =
  let res = List.map f (events seq) in
    res, (test_rev_sorted res)

let map_prev_next f seq =
  let rec map_prev_next_intern f prev l =
    match l with
      [] -> []
    | x :: [] -> [(f prev x None)]
    | x :: y :: tl ->
	let v = f prev x (Some y) in
	  v :: map_prev_next_intern f (Some x) (y :: tl)
  in
    let res = List.rev (map_prev_next_intern f None (events seq)) in
      res, (test_rev_sorted res)

let map_prev_next_cf f seq =
  let rec map_prev_next_cf_intern f prev cf l =
    match l with
      [] -> []
    | x :: [] -> let v, _ = f prev x None cf in [v]
    | x :: y :: tl ->
	let v, new_cf = f prev x (Some y) cf in
	  v :: map_prev_next_cf_intern f (Some x) (Some new_cf) (y :: tl)
  in
    let res = List.rev (map_prev_next_cf_intern f None None (events seq)) in
      res, (test_rev_sorted res)

let iter f seq =
  List.iter f (events seq)

let iter_cf f seq =
  let f2 x cf = Some (f cf x) in
    ignore (List.fold_left f2 None (events seq))
