(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

type 'a t = (Num.num * Num.num * 'a) list * bool
val create : unit -> 'a list * bool
val add :
  Num.num ->
  'a ->
  'b -> (Num.num * 'a * 'b) list * bool -> (Num.num * 'a * 'b) list * bool
val events : (Num.num * 'a * 'b) list * bool -> (Num.num * 'a * 'b) list
val merge :
  (Num.num * 'a * 'b) list * bool ->
  (Num.num * 'a * 'b) list * bool -> (Num.num * 'a * 'b) list * bool
val map :
  (Num.num * 'a * 'b -> Num.num * 'c * 'd) ->
  (Num.num * 'a * 'b) list * bool -> (Num.num * 'c * 'd) list * bool
val map_prev_next :
  ((Num.num * 'a * 'b) option ->
   Num.num * 'a * 'b -> (Num.num * 'a * 'b) option -> Num.num * 'c * 'd) ->
  (Num.num * 'a * 'b) list * bool -> (Num.num * 'c * 'd) list * bool
val map_prev_next_cf :
  ((Num.num * 'a * 'b) option ->
   Num.num * 'a * 'b ->
   (Num.num * 'a * 'b) option -> 'c option -> (Num.num * 'd * 'e) * 'c) ->
  (Num.num * 'a * 'b) list * bool -> (Num.num * 'd * 'e) list * bool
val iter :
  (Num.num * 'a * 'b -> unit) -> (Num.num * 'a * 'b) list * bool -> unit
val iter_cf :
  (Num.num * 'a * 'b -> 'c option -> 'c) ->
  (Num.num * 'a * 'b) list * bool -> unit
