(*

The main purpose of the release of this code is to demonstrate the
author's T2 algorithm for harmonic analysis of jazz chord sequences.

Permission for the use of this code is granted only for research,
educational, and non-commercial purposes.

Redistribution of this code or its parts in source, binary,
and any other form without permission, with or without modification,
is prohibited.  Modifications include, but are not limited to,
translation to other programming languages and reuse of tables,
constant definitions, and API's defined in it.

Andrew Choi is not liable for any losses or damages caused by the use
of this software.

Copyright 2008 Andrew Choi.
http://www.sixthhappiness.ca/T2/index.html

*)

open Num

exception Found of int

let index_array a v =
  let test i x = if x = v then raise (Found i) in
  try
    Array.iteri test a;
    raise Not_found
  with Found i ->
    i

let trim_right_string s =
  let rec loop i =
    if i > 0 && s.[i - 1] = ' ' then loop (i - 1) else i
  in
    Str.string_before s (loop ((String.length s)))

(* Pervasives.compare will not operate on nums that are ratios
(num_compare will).  So we need our own lookup routine instead of
using List.mem_assoc and List.assoc.  *)

let rec num_assoc x = function
    [] -> raise Not_found
  | (a, b) :: l -> if compare_num a x = 0 then b else num_assoc x l

let rec num_mem_assoc x = function
    [] -> false
  | (a, b) :: l -> compare_num a x = 0 || num_mem_assoc x l

